/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (26/05/08)
 */   
package com.ejie.p06b.excel;

import java.util.ArrayList;

import java.io.FileOutputStream;

import javax.servlet.http.HttpServletRequest;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.util.P06BResources;
import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.general.P06BConstantes;



/**
 * Clase que gestiona la generacin del pdf
 */
public class P06BListadoExcel implements P06BIExcel {
    private static long numeroEXCEL = 0;
	
	//Todo bien --> Devuelve la ruta donde dejaremos el excel
	//Error --> 1 Error al generar el EXCEL
    public String getEXCEL(HttpServletRequest request) throws Exception {
		P06BLog.send(2,"P06BListadoExcel", "getEXCEL(...)");
		
		String idioma = (String)request.getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);	
		if (idioma == null || idioma.equals("") ){
			idioma = P06BConstantes.P06B_IDIOMA_ES; //"es"
		}
		
		numeroEXCEL=numeroEXCEL+1;
		String error="1";
		
		//TODO COMPROBAR SI ESTA LINEA ES CORRECTA !!!!!!!
		String excelFichero = P06BParametros.get("excel.testExcel")+numeroEXCEL+".excel";
		//P06BLog.send(2,"P06BListadoExcel", "excelFichero:"+excelFichero);
		
		String where = (String)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"Corredor"+P06BConstantes.P06B_VAR_TEMP_FILTRO);
		P06BLog.send(2,"P06BListadoExcel - getEXCEL", "WHERE para el listado EXCEL: " + where);
		
		//Obtener el listado de corredores que cumplen los criterios de bsqueda
		ArrayList corredoresListadoExcel = P06BCorredoresManager.getInstance().selectCorredoresListadoBusqueda(where);
		try {			
			//create a new file
			FileOutputStream out = new FileOutputStream(excelFichero);
			//create a new workbook
			HSSFWorkbook wb = new HSSFWorkbook();
			//create a new sheet
			HSSFSheet s = wb.createSheet();
			//declare a row object reference
			HSSFRow r = null;
			//declare a cell object reference
			HSSFCell c = null;
			//create cell styles
			HSSFCellStyle cs = wb.createCellStyle();
			//create font object
			HSSFFont f = wb.createFont();
			
			
			//----- FORMATO DE LETRA: para los ttulos
			//arial is the default font
			//set font 1 to 11 point type
			f.setFontHeightInPoints((short) 11);
			//make it bold
			f.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);

			
			//----- CONFIGURAR EL ESTILO DE CELDA
			//set cell stlye
			cs.setFont(f);
			//set a thin border
			cs.setBorderBottom((short)2);
			//fill color: fondo
			//cs.setFillPattern((short)0x8);

			
			//----- DAR EL NOMBRE A LA HOJA DEL FICHERO EXCEL
//			wb.setSheetName(0, ((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.listado"), HSSFWorkbook.ENCODING_UTF_16 );
			wb.setSheetName(0, ((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.listado") );
				
			
			//----- CONFIGURAR EL TAMAO DE LAS COLUMNAS
			s.setColumnWidth(0, 4000);
			s.setColumnWidth(1, 4000);
			s.setColumnWidth(2, 20000);
			s.setColumnWidth(3, 4000);
			
			
			//----- LOS TITULOS DE LA TABLA
			r = s.getRow(0);
			if (r==null) r=s.createRow(0);
			
			c = r.getCell(0);
            if (c==null){
            	c = r.createCell(0);
            }
            c.setCellStyle(cs);
            c.setCellValue(((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.exp"));
            
            c = r.getCell(1);
            if (c==null){
            	c = r.createCell(1);
            }
            c.setCellStyle(cs);
            c.setCellValue(((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.nifCif"));
            
            c = r.getCell(2);
            if (c==null){
            	c = r.createCell(2);
            }
            c.setCellStyle(cs);
            c.setCellValue(((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.mediador"));
            
            c = r.getCell(3);
            if (c==null){
            	c = r.createCell(3);
            }
            c.setCellStyle(cs);
            c.setCellValue(((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.estado"));
			
            
            //----- EL CONTENIDO DEL LISTADO
			//Numero de linea en la que empieza el listado, en la cero van los titulos y en la 1 comienza el listado.
			int numInicioListado = 1;
			
			if(corredoresListadoExcel != null && corredoresListadoExcel.size()>0){							
				P06B20T00Datatype corredor = null;
				for(int i=0;i<corredoresListadoExcel.size();i++){
					corredor = (P06B20T00Datatype)corredoresListadoExcel.get(i);
					
					r = s.getRow(i+numInicioListado);
		            if (r==null) r=s.createRow(new Integer(i+numInicioListado).intValue());
		            
		            //Expediente
		            c = r.getCell(0);
		            if (c==null){
		            	c = r.createCell(0);
		            }
		            c.setCellValue((corredor.getExpedi()==null)?"":corredor.getExpedi());
		            
		            //CIF_DNI
		            c = r.getCell(1);
		            if (c==null){
		            	c = r.createCell(1);
		            }
		            c.setCellValue((corredor.getDni()==null)?"":corredor.getDni());
		            		            
		            //Corredor
		            c = r.getCell(2);
		            if (c==null){
		            	c = r.createCell(2);
		            }
			      	if (P06BConstantes.P06B_PERSONA_FISICA.equals(corredor.getClase())){
			      		c.setCellValue(((corredor.getNombre()==null)?"":corredor.getNombre()) +" "+ ((corredor.getApe1()==null)?"":corredor.getApe1()) +" "+ ((corredor.getApe2()==null)?"":corredor.getApe2()));			 	
			      	}else{
			      		c.setCellValue(((corredor.getRazsoc()==null)?"":corredor.getRazsoc()));
			      	}
			      	
			      	//Estado
		            c = r.getCell(3);
		            if (c==null){
		            	c = r.createCell(3);
		            }
		            if (P06BConstantes.P06B_CORREDORES_ESTADO_ALTA.equals(corredor.getEstado())){
		            	c.setCellValue(((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.alta"));
				  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_BAJA.equals(corredor.getEstado())){
				  		c.setCellValue(((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.baja"));
				  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_SUSPENSION.equals(corredor.getEstado())){
				  		c.setCellValue(((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.suspension"));
				  	}
		            
				}//fin del for(int i=0;i<corredoresListadoExcel.size();i++){				
			}//fin del if(corredoresListadoExcel != null && corredoresListadoExcel.size()>0){
						
			
			//----- HOJA DE CRITERIOS
			//WHERE P06B20_NUMEXP LIKE '%F%' AND P06B20_CLASE = 'F' AND P06B20_ESTADO = 'A' AND P06B20_IDENTIFICADOR LIKE '%48%' AND P06B20_NOMBRE LIKE '%MAR%' AND P06B20_APE1 LIKE '%ABA%' AND P06B20_APE2 LIKE '%ARA%'"
			//WHERE P06B20_NUMEXP LIKE '%J%' AND P06B20_CLASE = 'J' AND P06B20_ESTADO = 'A' AND P06B20_IDENTIFICADOR LIKE '%48%' AND P06B20_RAZSOC LIKE '%SS%'"
			/*if(where != null && where.length()>0){
				int primeraPosicion = where.indexOf("P06B20_NUMEXP");
				if(primeraPosicion != -1){
				}
			}*/
			
			
			wb.write(out);
			out.close();
			
		}catch( Exception e) {
			P06BLog.send(2,"P06BListadoExcel", "Error al generar excel:"+e.getMessage());
			return error;
		}
		return excelFichero;
	}
}